/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlnk;

import java.io.File;
import java.io.PrintWriter;
import uk.co.demon.obelisk.xlnk.CachedTarget;
import uk.co.demon.obelisk.xobj.Hex;

class S19Target
extends CachedTarget {
    private int addrSize;

    public S19Target(int start, int end, int addrSize) {
        this(start, end, addrSize, 8);
    }

    public S19Target(long start, long end, int addrSize, int byteSize) {
        super(start, end, byteSize);
        this.addrSize = addrSize;
    }

    public void writeTo(File file) {
        int count = 0;
        try {
            int total;
            PrintWriter writer = new PrintWriter(file);
            int index = 0;
            while (index < this.size) {
                long addr = this.start + (long)index;
                writer.print('S');
                total = 0;
                int bytes = this.size - index;
                if (bytes > 32) {
                    bytes = 32;
                }
                switch (this.addrSize) {
                    case 16: {
                        writer.print('1');
                        writer.print(Hex.toHex(bytes + 3, 2));
                        total += bytes + 3;
                        writer.print(Hex.toHex(addr, 4));
                        total = (int)((long)total + (addr >> 8 & 0xFFL));
                        total = (int)((long)total + (addr >> 0 & 0xFFL));
                        break;
                    }
                    case 24: {
                        writer.print('2');
                        writer.print(Hex.toHex(bytes + 4, 2));
                        total += bytes + 4;
                        writer.print(Hex.toHex(addr, 6));
                        total = (int)((long)total + (addr >> 16 & 0xFFL));
                        total = (int)((long)total + (addr >> 8 & 0xFFL));
                        total = (int)((long)total + (addr >> 0 & 0xFFL));
                        break;
                    }
                    case 32: {
                        writer.print('3');
                        writer.print(Hex.toHex(bytes + 5, 2));
                        total += bytes + 5;
                        writer.print(Hex.toHex(addr, 8));
                        total = (int)((long)total + (addr >> 24 & 0xFFL));
                        total = (int)((long)total + (addr >> 16 & 0xFFL));
                        total = (int)((long)total + (addr >> 8 & 0xFFL));
                        total = (int)((long)total + (addr >> 0 & 0xFFL));
                    }
                }
                int offset = 0;
                while (offset < bytes) {
                    writer.print(Hex.toHex(this.code[index + offset], 2));
                    total += this.code[index + offset];
                    ++offset;
                }
                writer.print(Hex.toHex(~total & 0xFF, 2));
                writer.println();
                ++count;
                index += 32;
            }
            total = 0;
            writer.print('S');
            writer.print('5');
            writer.print("05");
            total += 5;
            writer.print(Hex.toHex(count, 8));
            total += count >> 24 & 0xFF;
            total += count >> 16 & 0xFF;
            total += count >> 8 & 0xFF;
            writer.print(Hex.toHex(~(total += count >> 0 & 0xFF) & 0xFF, 2));
            writer.println();
            total = 0;
            writer.print('S');
            switch (this.addrSize) {
                case 16: {
                    writer.print('9');
                    writer.print("03");
                    total += 3;
                    writer.print(Hex.toHex(this.start, 4));
                    total = (int)((long)total + (this.start >> 8 & 0xFFL));
                    total = (int)((long)total + (this.start >> 0 & 0xFFL));
                    break;
                }
                case 24: {
                    writer.print('8');
                    writer.print("04");
                    total += 4;
                    writer.print(Hex.toHex(this.start, 6));
                    total = (int)((long)total + (this.start >> 16 & 0xFFL));
                    total = (int)((long)total + (this.start >> 8 & 0xFFL));
                    total = (int)((long)total + (this.start >> 0 & 0xFFL));
                    break;
                }
                case 32: {
                    writer.print('7');
                    writer.print("05");
                    total += 5;
                    writer.print(Hex.toHex(this.start, 8));
                    total = (int)((long)total + (this.start >> 24 & 0xFFL));
                    total = (int)((long)total + (this.start >> 16 & 0xFFL));
                    total = (int)((long)total + (this.start >> 8 & 0xFFL));
                    total = (int)((long)total + (this.start >> 0 & 0xFFL));
                }
            }
            writer.print(Hex.toHex(~total & 0xFF, 2));
            writer.println();
            writer.close();
        }
        catch (Exception error) {
            System.err.println("Error: A serious error occurred writing the object module.");
        }
    }
}

